/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.Token;
import java.util.StringTokenizer;

class OiList {
    String[] list;
    int numOIs;
    int numScalarOIs;
    int numWildcardOIs;
    int[] scalarIndexes;
    int[] wildcardIndexes;
    int sysUpTimeIndex = -1;

    protected OiList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+-*/,&=|<>?:");
        this.list = new String[stringTokenizer.countTokens() + 1];
    }

    protected String elementAt(int n) {
        return this.list[n];
    }

    protected int size() {
        return this.numOIs;
    }

    protected int getSysUpTimeIndex() {
        return this.sysUpTimeIndex;
    }

    protected void setWildcardVsScalar() {
        if (this.sysUpTimeIndex == -1) {
            this.sysUpTimeIndex = this.numOIs;
            this.list[this.numOIs] = "1.3.6.1.2.1.1.3.0";
            ++this.numOIs;
        }
        int n = 0;
        while (n < this.numOIs) {
            if (this.isWildcard(this.list[n])) {
                ++this.numWildcardOIs;
            } else {
                ++this.numScalarOIs;
            }
            ++n;
        }
        this.scalarIndexes = new int[this.numScalarOIs];
        this.wildcardIndexes = new int[this.numWildcardOIs];
        this.numScalarOIs = 0;
        this.numWildcardOIs = 0;
        int n2 = 0;
        while (n2 < this.numOIs) {
            if (this.isWildcard(this.list[n2])) {
                this.wildcardIndexes[this.numWildcardOIs++] = n2;
            } else {
                this.scalarIndexes[this.numScalarOIs++] = n2;
            }
            ++n2;
        }
    }

    protected boolean containsRelativeIndex() {
        int n = 0;
        while (n < this.numOIs) {
            if (this.list[n].indexOf(36) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected static boolean containsRelativeIndex(String string) {
        return string.indexOf(36) != -1;
    }

    protected boolean isWildcard(String string) {
        return string.endsWith(".*");
    }

    protected int getOIcount() {
        return this.numOIs;
    }

    protected int getScalarOIcount() {
        return this.numScalarOIs;
    }

    protected int getWildcardOIcount() {
        return this.numWildcardOIs;
    }

    protected int[] getScalarIndexes() {
        return this.scalarIndexes;
    }

    protected int[] getWildcardIndexes() {
        return this.wildcardIndexes;
    }

    protected String[] getScalarOIs() {
        String[] stringArray = new String[this.numScalarOIs];
        int n = 0;
        while (n < this.numScalarOIs) {
            stringArray[n] = this.list[this.scalarIndexes[n]];
            ++n;
        }
        return stringArray;
    }

    protected String[] getWildcardOIs() {
        String[] stringArray = new String[this.numWildcardOIs];
        int n = 0;
        while (n < this.numWildcardOIs) {
            String string = this.list[this.wildcardIndexes[n]];
            stringArray[n] = string.substring(0, string.length() - 2);
            ++n;
        }
        return stringArray;
    }

    protected int addOI(Token token, char[] cArray) {
        if (token.string != null) {
            return this.addOI(token.string);
        }
        return this.addOI(new String(cArray, token.begin, token.length));
    }

    protected int addOI(String string) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.numOIs) {
            if (this.list[n2].equals(string)) {
                bl = true;
                n = n2;
                break;
            }
            if (this.sysUpTimeIndex == -1 && "1.3.6.1.2.1.1.3.0".equals(string)) {
                this.sysUpTimeIndex = n2;
            }
            ++n2;
        }
        if (!bl) {
            this.list[this.numOIs] = new String(string);
            n = this.numOIs++;
        }
        return n;
    }
}

